/*
 * $Id$
 *
 * A point class with and without fixed-size memory manager guided by USE_MM.
 *
 * Created by: WeeSan Lee <weesan@cs.ucr.edu>
 */

#ifndef POINT_H
#define POINT_H

#ifdef USE_MM
#include "mem_mgr.h"
#endif

class Point {
private:
    int iX, iY;

public:
    Point(int iX = 0, int iY = 0) :
	iX(iX),
	iY(iY) {
    }
    int x(void) const {
	return (iX);
    }
    int y(void) const {
	return (iY);
    }
#ifdef USE_MM
    void *operator new(size_t size);
    void operator delete(void *p);
#endif
};

#endif // POINT_H
